/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.api.config;

import com.flemmli97.tenshilib.api.config.SimpleItemStackWrapper;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;

public class ExtendedItemStackWrapper
extends SimpleItemStackWrapper {
    protected CompoundNBT nbtTagCompound;

    public ExtendedItemStackWrapper(CompoundNBT compound) {
        this(compound.func_74779_i("id"), compound.func_74762_e("Count"), compound.func_74775_l("nbt"));
    }

    public ExtendedItemStackWrapper(String item) {
        this(item, 1);
    }

    public ExtendedItemStackWrapper(String item, int count) {
        this(item, count, null);
    }

    public ExtendedItemStackWrapper(String item, int count, CompoundNBT nbt) {
        super(item, count);
    }

    public ExtendedItemStackWrapper setNBT(CompoundNBT nbt) {
        this.nbtTagCompound = nbt;
        return this;
    }

    public ExtendedItemStackWrapper ignoreNBT() {
        this.nbtTagCompound = null;
        return this;
    }

    @Override
    public ExtendedItemStackWrapper readFromString(String s) {
        try {
            CompoundNBT nbt = JsonToNBT.func_180713_a((String)s);
            this.nbtTagCompound = nbt.func_74775_l("nbt");
            this.count = nbt.func_74762_e("Count");
            this.reg = nbt.func_74779_i("id");
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public String writeToString() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("nbt", (INBT)this.nbtTagCompound.func_74737_b());
        nbt.func_74778_a("id", this.item.getRegistryName().toString());
        nbt.func_74768_a("Count", this.count);
        return nbt.toString();
    }

    public static String usage() {
        return "Complete ItemStack nbt (meaning with id and count)";
    }

    @Nullable
    public CompoundNBT getTag() {
        return this.nbtTagCompound == null ? null : this.nbtTagCompound.func_74737_b();
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = super.getStack();
        if (!stack.func_190926_b() && this.nbtTagCompound != null) {
            stack.func_77982_d(this.nbtTagCompound.func_74737_b());
        }
        return stack;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExtendedItemStackWrapper) {
            ExtendedItemStackWrapper prop = (ExtendedItemStackWrapper)obj;
            return prop.toString().equals(this.toString());
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<ExtendedItemStackWrapper>,
    JsonSerializer<ExtendedItemStackWrapper> {
        public JsonElement serialize(ExtendedItemStackWrapper src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("item", (JsonElement)new JsonPrimitive(src.reg));
            if (src.count != 1) {
                obj.add("count", (JsonElement)new JsonPrimitive((Number)src.count));
            }
            if (src.nbtTagCompound != null) {
                obj.add("nbt", (JsonElement)new JsonPrimitive(src.nbtTagCompound.toString()));
            }
            return obj;
        }

        public ExtendedItemStackWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int count = 1;
            if (obj.get("count") instanceof JsonPrimitive && obj.get("count").getAsJsonPrimitive().isNumber()) {
                count = obj.get("count").getAsInt();
            }
            JsonObject nbt = obj.has("nbt") ? obj.get("nbt").getAsJsonObject() : null;
            CompoundNBT compound = null;
            if (nbt != null) {
                try {
                    compound = JsonToNBT.func_180713_a((String)nbt.toString());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            return new ExtendedItemStackWrapper(obj.get("item").getAsString(), count, compound);
        }
    }
}

